package com.ejie.ab18a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.dao.Ab18aTicketPeticionDao;
import com.ejie.ab18a.model.Ab18aTicketPeticion;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab18a07s00ServiceImpl generated by XXXX, 03-feb-2017 12:08:05.
 * 
 * @author XXXX
 */

@Service(value = "ab18aTicketPeticionService")
public class Ab18aTicketPeticionServiceImpl implements
		Ab18aTicketPeticionService {

	@Autowired
	private Ab18aTicketPeticionDao ab18aTicketPeticionDao;

	/**
	 * Inserts a single row in the Ab18a07s00 table.
	 * 
	 * @param ab18aTicketPeticion
	 *            Ab18aTicketPeticion
	 * @return Ab18aTicketPeticion
	 * @throws Exception
	 *             the exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aTicketPeticion add(Ab18aTicketPeticion ab18aTicketPeticion)
			throws Exception {
		return this.ab18aTicketPeticionDao.add(ab18aTicketPeticion);
	}

	/**
	 * Updates a single row in the Ab18a07s00 table.
	 * 
	 * @param ab18aTicketPeticion
	 *            Ab18aTicketPeticion
	 * @return Ab18aTicketPeticion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ab18aTicketPeticion update(Ab18aTicketPeticion ab18aTicketPeticion) {
		return this.ab18aTicketPeticionDao.update(ab18aTicketPeticion);
	}

	/**
	 * Finds a single row in the Ab18a07s00 table.
	 * 
	 * @param ab18aTicketPeticion
	 *            Ab18aTicketPeticion
	 * @return Ab18aTicketPeticion
	 */
	public Ab18aTicketPeticion find(Ab18aTicketPeticion ab18aTicketPeticion) {
		return (Ab18aTicketPeticion) this.ab18aTicketPeticionDao
				.find(ab18aTicketPeticion);
	}

	/**
	 * Deletes a single row in the Ab18a07s00 table.
	 * 
	 * @param ab18aTicketPeticion
	 *            Ab18aTicketPeticion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ab18aTicketPeticion ab18aTicketPeticion) {
		this.ab18aTicketPeticionDao.remove(ab18aTicketPeticion);
	}

	/**
	 * Finds a list of rows in the Ab18a07s00 table.
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a07s00>
	 */
	public List<Ab18aTicketPeticion> findAll(Ab18aTicketPeticion ab18a07s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Ab18aTicketPeticion>) this.ab18aTicketPeticionDao.findAll(
				ab18a07s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab18a07s00 table using like.
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a07s00>
	 */
	public List<Ab18aTicketPeticion> findAllLike(
			Ab18aTicketPeticion ab18a07s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return (List<Ab18aTicketPeticion>) this.ab18aTicketPeticionDao
				.findAllLike(ab18a07s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab18a07s00 table.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Ab18aTicketPeticion filterAb18a07s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab18aTicketPeticionDao.removeMultiple(filterAb18a07s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab18a07s00 table.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Ab18a07s00>
	 */
	public JQGridResponseDto<Ab18aTicketPeticion> filter(
			Ab18aTicketPeticion filterAb18a07s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Ab18aTicketPeticion> listaAb18a07s00 = this.ab18aTicketPeticionDao
				.findAllLike(filterAb18a07s00, jqGridRequestDto, false);
		Long recordNum = this.ab18aTicketPeticionDao.findAllLikeCount(
				filterAb18a07s00 != null ? filterAb18a07s00
						: new Ab18aTicketPeticion(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Ab18aTicketPeticion>> reorderSelection = this.ab18aTicketPeticionDao
					.reorderSelection(filterAb18a07s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Ab18aTicketPeticion>(jqGridRequestDto,
					recordNum, listaAb18a07s00, reorderSelection);
		}
		return new JQGridResponseDto<Ab18aTicketPeticion>(jqGridRequestDto,
				recordNum, listaAb18a07s00);
	}

	/**
	 * Searches rows in the Ab18a07s00 table.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00
	 * @param searchAb18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a07s00>>
	 */
	public List<TableRowDto<Ab18aTicketPeticion>> search(
			Ab18aTicketPeticion filterAb18a07s00,
			Ab18aTicketPeticion searchAb18a07s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab18aTicketPeticionDao.search(filterAb18a07s00,
				searchAb18a07s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab18a07s00 table.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Ab18aTicketPeticion filterAb18a07s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab18aTicketPeticionDao.reorderSelection(filterAb18a07s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab18a07s00 table.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a07s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aTicketPeticion>> jerarquia(
			Ab18aTicketPeticion filterAb18a07s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<JerarquiaDto<Ab18aTicketPeticion>> listaAb18a07s00 = this.ab18aTicketPeticionDao
				.findAllLikeJerarquia(filterAb18a07s00, jqGridRequestDto);
		Long recordNum = this.ab18aTicketPeticionDao.findAllLikeCountJerarquia(
				filterAb18a07s00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Ab18aTicketPeticion>>(
				jqGridRequestDto, recordNum, listaAb18a07s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab18a07s00 table.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Ab18a07s00>>
	 */
	public JQGridResponseDto<JerarquiaDto<Ab18aTicketPeticion>> jerarquiaChildren(
			Ab18aTicketPeticion filterAb18a07s00,
			JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Ab18aTicketPeticion>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Ab18aTicketPeticion>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.ab18aTicketPeticionDao.findAllChild(filterAb18a07s00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}
}
